import java.io.IOException;

public abstract class Account {
	
	private double myBalance;
	private Person myOwner;
	private FinancialInstitution myF;

	
	/**Constructor: Sets the balance of the account, and the owner of the account **/
	public Account(double startBalance, FinancialInstitution f, Person owner){
		myBalance = startBalance;
		myOwner = owner;
		myF     = f;
	}
	
	/**Deposits money into the account if it verifies your password *
	 * @throws IOException */
	public void deposit(double amt) throws IOException{
		if( myOwner.requestPassword()) {
			Transfer.transfer(myOwner, this, amt);
		}
	}
	
	/**Withdraws money into the account if it verifies your password *
	 * @throws IOException */
	public void withdraw(double amt) throws IOException{
		if( myOwner.requestPassword()){
			Transfer.transfer(this, myOwner, amt);
		}
	}
	
	/**Accessor: returns the current balance **/
	public double getBalance(){
		return myBalance;
	}
	
	/** Sets the current balance **/
	public void setBalance(double b){
		myBalance = b;
	}
	
	/**Accessor: returns the owner of the account **/
	public Person getOwner(){
		return myOwner;
	}
	
	/** Accessor: Returns the location of the financial institution. **/
	public FinancialInstitution getLocation(){
		return myF;
		
	}
	
	
	
}
